'use strict';

function MessageCtrl($scope, $rootScope){

    $scope.title = 'Test';
    $scope.message = 'Some message';

    $scope.messages = [];

    angular.element('#modal-message').modal({
        backdrop: 'static'
        ,keyboard: false
        ,show: false
    })


    $scope.openModal = function(){
        angular.element('#modal-message').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-message').modal('hide');
    }

    $scope.$on('Message:addMsg', function(event, obj){
        $scope.messages.push(obj);
        $scope.openModal();
        $scope.$apply();
    });

    $scope.$on('Message:delMsg', function(event, obj){
        $scope.messages.splice($scope.messages.indexOf(obj), 1);
        $scope.$apply();
        if($scope.messages.length == 0)
        {
            $scope.closeModal();
        }
    });
}

MessageCtrl.$inject = ['$scope', '$rootScope'];